PACKAGE my_pack IS
  TYPE nineval IS (Z0, Z1, ZX,
                   R0, R1, RX,
                   F0, F1, FX);

  TYPE nvector2 IS ARRAY(0 TO 1) OF nineval;
  TYPE fourstate IS (X, L, H, Z);

  FUNCTION convert4state(a : fourstate)
    RETURN nineval;

  FUNCTION convert9val(a : nineval)
    RETURN fourstate;

END my_pack;

PACKAGE body my_pack IS
  FUNCTION convert4state(a : fourstate)
    RETURN nineval IS
  BEGIN
    CASE a IS
      WHEN X =>
        RETURN FX;
      WHEN L =>
        RETURN F0;
      WHEN H =>
        RETURN F1;
      WHEN Z =>
        RETURN ZX;
    END CASE;
  END convert4state;

  FUNCTION convert9val(a : nineval)
    RETURN fourstate IS
  BEGIN
    CASE a IS
      WHEN Z0 =>
        RETURN Z;
      WHEN Z1 =>
        RETURN Z;
      WHEN ZX =>
        RETURN Z;
      WHEN R0 =>
        RETURN L;
      WHEN R1 =>
        RETURN H;
      WHEN RX =>
        RETURN X;
      WHEN F0 =>
        RETURN L;
      WHEN F1 =>
        RETURN H;
      WHEN FX =>
        RETURN X;
    END CASE;
  END convert9val;
END my_pack;

USE WORK.my_pack.ALL;
ENTITY trans2 IS
  PORT( a, b : INOUT nvector2;
        enable : IN nineval);
END trans2;

ARCHITECTURE struct OF trans2 IS
  COMPONENT trans
    PORT( x1, x2 : INOUT fourstate;
          en : IN fourstate);
  END COMPONENT;
BEGIN
  U1 : trans PORT MAP(
    convert4state(x1) => convert9val(a(0)),
    convert4state(x2) => convert9val(b(0)),
    en => convert9val(enable) );

  U2 : trans PORT MAP(
    convert4state(x1) => convert9val(a(1)),
    convert4state(x2) => convert9val(b(1)),
    en => convert9val(enable) );
END struct;

